//***************************************************************************
//
//  SRCENTSL.H
//
//  Header File for Application Programming Interface for
//  SRC Enterprises Slider Custom Control (SRCENTSL.DLL)
//
//  Copyright (c) 1996 Steven R Clabaugh
//
//***************************************************************************
#ifndef _INCL_SRCENTSL_H
#define _INCL_SRCENTSL_H

//**********************************************************
// Slider Styles
//**********************************************************

#define SL_REVERSED  0x0004    // Reversed          style bit
#define SL_HORZ      0x0010    // Horizontal        style bit
#define SL_THERM     0x0020    // Thermometer guage style bit

//**********************************************************
// Slider Custom Control API Functions
//**********************************************************
#ifdef __cplusplus
extern "C" {
#endif  // __cplusplus

HWND FAR PASCAL _export SRCEntSLCreate(DWORD, LPSTR, LPSTR, int, int, int,
                                       int, int, int, int, int, BOOL, BOOL,
                                       HWND, HMENU, HINSTANCE);
VOID FAR PASCAL _export SRCEntSLEnableMouse(HWND, BOOL);
VOID FAR PASCAL _export SRCEntSLGetRange(HWND, LPINT, LPINT);
int  FAR PASCAL _export SRCEntSLGetRevVal(HWND);
int  FAR PASCAL _export SRCEntSLGetVal(HWND);
VOID FAR PASCAL _export SRCEntSLInit(HWND, LPSTR, LPSTR, int, int, int, int,
                                     int, int, BOOL, BOOL);
VOID FAR PASCAL _export SRCEntSLSetFace(HWND, LPSTR);
VOID FAR PASCAL _export SRCEntSLSetHand(HWND, BOOL);
VOID FAR PASCAL _export SRCEntSLSetKnob(HWND, LPSTR, int, int, int, BOOL);
VOID FAR PASCAL _export SRCEntSLSetRange(HWND, int, int, BOOL);
int  FAR PASCAL _export SRCEntSLSetVal(HWND, int, BOOL);

#ifdef __cplusplus
}
#endif  // __cplusplus

//***************************************************************************
//***************************************************************************
//***************************************************************************
//
//  SRCEntSL Class Definition
//
//***************************************************************************
//***************************************************************************
//***************************************************************************
#ifdef __cplusplus

class FAR CSRCEntSL
{

   //****************************************************************
   //***********************  Member Data  **************************
   //****************************************************************

   private:

      HWND m_hSlider;

   //****************************************************************
   //***********************  Member Functions  *********************
   //****************************************************************

   public:

      // Constructor/Destructor
      FAR PASCAL _export CSRCEntSL();
      FAR PASCAL _export ~CSRCEntSL();

      // Overloaded operators
      void FAR PASCAL _export operator+=(int x);
      void FAR PASCAL _export operator-=(int x);
      void FAR PASCAL _export operator++();      // prefix
      void FAR PASCAL _export operator++(int);   // postfix
      void FAR PASCAL _export operator--();      // prefix
      void FAR PASCAL _export operator--(int);   // postfix

      // Creates a Slider (DO NOT use STRICT Type Handles)
      UINT FAR PASCAL _export Create(
                  DWORD Style,
                  LPSTR FaceName,
                  LPSTR KnobName,
                  int   X,
                  int   Y,
                  int   ks,
                  int   kt,
                  int   kb,
                  int   rmin,
                  int   rmax,
                  int   val,
                  BOOL  bHand,
                  BOOL  bMouse,
                  UINT  hParent,  //Cast this to UINT in application code
                  UINT  ID,       //Cast this to UINT in application code
                  UINT  hInst     //Cast this to UINT in application code
                 );

      UINT FAR PASCAL _export GetHandle();
      void FAR PASCAL _export EnableMouse(BOOL bMouse);
      void FAR PASCAL _export GetRange(LPINT lpMin, LPINT lpMax);
      int  FAR PASCAL _export GetRevVal();
      int  FAR PASCAL _export GetVal();
      void FAR PASCAL _export SetFace(LPSTR FaceName);
      void FAR PASCAL _export SetHand(BOOL bHand);
      void FAR PASCAL _export SetKnob(LPSTR KnobName,int ks,int kt,int kb,
                                      BOOL bRedraw);
      void FAR PASCAL _export SetRange(int nMin, int nMax, BOOL bRedraw);
      int  FAR PASCAL _export SetVal(int nVal, BOOL Redraw);

}; // End CSRCEntSL Slider Custom Control Class Definition

#endif // __cplusplus
#endif // _INCL_SRCENTSL_H
